/**
 * Perform user pre-timeout actions
 */
package gov.va.med.mhv.login.hook;

import java.util.Date;

import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.auth.AuthException;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.login.hook.SystemDownException.ErrorCodeEnum;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PerformerTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountValidatorService;


/**
 * @author DNS
 *
 */
@Component
public class CustomPreSessionExpireAction extends SessionAction {

	private static Log log = LogFactoryUtil.getLog(CustomPreSessionExpireAction.class);

	private static final String SESSION_USERNAME_KEY = "LIFERAY_SHARED_userid";
	private static final String SESSION_USERPROFILEID_KEY = "LIFERAY_SHARED_userprofileid";
	private AccountValidatorService accountValidatorService;

	//When user session times out an AAL entry is added to Activity table for audit purposes
    @Override
    public void run(HttpSession session) throws ActionException {
		try {
			String username=null;
			Long userProfileId=null;
			if(session!=null){
				if(session.getAttribute(SESSION_USERNAME_KEY) != null){
					username = (String)session.getAttribute(SESSION_USERNAME_KEY);
				}
				if(session.getAttribute(SESSION_USERPROFILEID_KEY) != null){
					userProfileId= (Long)session.getAttribute(SESSION_USERPROFILEID_KEY);
				}
			}else{
				if(log.isDebugEnabled()){
					log.debug("****Session is null****");
				}
			}
			
			if(username != null &&  userProfileId != null){
				// Create AAL entry
				if (session.getAttribute("requestURL") == null || !session.getAttribute("requestURL").toString().contains("portal/logout")){
					// AAL entry
					createTimeoutActivity(username,userProfileId);
				}
			}
		} catch (Exception e) {
			log.error("Error in CustomPreSessionExpireAction for user: ", e);
		}

    }

	private void createTimeoutActivity(String username, Long userProfileId) throws AuthException{
		try {
			ActivityDTO timeoutActivity = new ActivityDTO();
			timeoutActivity.setAction(ActivityActionTypeEnumeration.SESSION_TIMEOUT.getDescription());
			timeoutActivity.setActivityType("Logout");
			timeoutActivity.setUserProfileId(userProfileId);
			timeoutActivity.setStatus(Boolean.TRUE);
			timeoutActivity.setPerformerType(PerformerTypeEnumeration.valueOf("System").toString());
			timeoutActivity.setDetailValue("None");
			timeoutActivity.setCompletionTime(new Date());

			//getAccountActivityCreatorService().createAccountActivityLog(timeoutActivity);
			// Using AccountValidatorService instead of AccountActivityCreatorService because of the constraints of service calls from hooks
			getAccountValidatorService().createAccountActivityLog(timeoutActivity);

		} catch (MHVException e) {
			log.error("Error Creating Account Activity Log - Session timeout", e);
			throw new AuthException("Error Creating Account Activity Log Service.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE, e));
		}
	}

	private AccountValidatorService getAccountValidatorService() {
		if (this.accountValidatorService == null) {
			this.accountValidatorService = (AccountValidatorService) ApplicationContextProvider.getApplicationContext()
					.getBean("accountValidatorServiceProxy");
		}
		return this.accountValidatorService;
	}
}
